package com.js.common.constant;

/**
 * Created by admin on 2016/4/27.
 */
public class Constant {

    /** 接口版本控制 */
    public interface  ApiPath{
        String V1 = "/api/v1";
    }

    /** 接口权限 方便拦截过滤 */
    public interface  ApiLoginAuth{
        /** 都可以访问，无需拦截 */
        String ANON = "/anon";
        /** 需要做拦截，判断是否用户登录之类的要求 */
        String AUTHC = "/authc";
    }

    /**
     * @Author yjzhao
     * @Description 是否删除
     *  DelFlag.NO  不删除
     *  DelFlag.YES 删除
     * @Date 2018/10/30 9:01
     * @Param
     * @return
     **/
    public interface  DelFlag{
        Integer NO = 0;
        Integer YES = 1;
    }

    /**
     * 一些项目固定常量
     */
    public interface ProjectConstant {
        //系统创建name
        String CREATE_NAME = "sys";
        //系统创建id
        Long CREATE_ID = 0L;
    }

    /** 前台 token参数头 */
    public static final String HEADER_X_HO_TOKEN = "Authorization";

    /** redis用户信息 key头部 */
    public static final String REDIS_JS_WEB_USER ="JSWEBUSER:";

    /** redis用户短信 key头部 */
    public static final String REDIS_JS_USER_SMS ="JSUSERSMS:";

    /** redis银行信息 key头部 */
    public static final String REDIS_JS_PAY_BANCK ="JSPAYBANCK:";

    /** 存储外汇查询信息 key头部 */
    public static final String REDIS_JS_WEB_USER_WAIHUI ="JSWAIHUI:";

    /** 登陆不操作过期时间 */
    public static final Integer LOGIN_TIMEOUT = 3600;

    /** redis-database */
    public static final Integer REDIS_DATABASE = 0;

    /** 错误最大次数 */
    public static final Integer ERROR_MAX_COUNT = 5;

    /** dubbo 版本 */
    public static final String DUBBO_VERSION = "1.0.0";

    /** 密码加密私钥redis存放头 */
    public static final String REDIS_JS_WEB_PWD_KEY = "PWDKEY:";
    /** 密码加密私钥redis存放超时时间 */
    public static final Integer REDIS_JS_WEB_PWD_KEY_TIMEOUT = 1000;

    /** 生成 token 中 key 名称 */
    public static final String TOKEN_KEY_NAME = "id";
}
