package com.js.common.config.aliyun;

import com.aliyun.oss.OSSClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class AliyunOSSClientFactoryBean implements FactoryBean<OSSClient>, InitializingBean, DisposableBean {

    private OSSClient ossClient;

    private String endpoint;

    private String accessKeyId;

    private String accessKeySecret;


    @Override
    public void destroy() throws Exception {
        if (this.ossClient != null){
            this.ossClient.shutdown();
        }
    }

    @Override
    public OSSClient getObject() throws Exception {
        return this.ossClient;
    }

    @Override
    public Class<?> getObjectType() {
        return OSSClient.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }
}
