package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 还款操作
 */
@Data
public class RepaymentOperationReq implements Serializable {
    private static final long serialVersionUID = 122173851639481470L;

    /**
     * 贷款编号
     */
    @NotBlank(message = "贷款编号不能为空")
    private String loanNo;
    /**
     * 还款总金额
     */
    @NotNull(message = "还款总金额不能为空")
    @Min(value = 0,message = " 还款总金额不能为0")
    private BigDecimal repaymentAllAmt;
    /**
     * 还款账户编号
     */
    private BigDecimal accountNo;
    /**
     * 还款本金
     */
    private BigDecimal principalAmt;
    /**
     * 手续费
     */
    private BigDecimal proceduresAmt;
    /**
     * 利息
     */
    private BigDecimal plannedInterest;
    /**
     * 费用
     */
    private BigDecimal plannedInstFee;

    /**
     * KYC用户ID
     */
    private String kycNaturalId;

}
