package com.js.common.model.req;

import com.js.common.annotation.Phone;
import com.js.common.enums.BankAcctTypeEnum;
import com.js.common.enums.BankAreaType;
import com.js.common.enums.SysPlateformType;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

@Data
public class KycLoanBankReq implements Serializable {
    private static final long serialVersionUID = -4338274747671397115L;

    private String kycNaturalId;

    /**
     * 银行卡用户名
     */
    @NotBlank(message = "银行卡户名不能为空.")
    private String accountName;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空.")
    private String accountNo;


    /**
     * 银行卡预留手机号
     */
    @NotBlank(message = "银行卡预留手机号不能为空.")
    @Phone
    private String phone;

    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空.")
    private String bankName;

    /**
     * 银行编码
     */
    private String bankCode;

    /** 标识 */
    @NotBlank(message = "请确认标识是否填写.")
    private String markStr;

    /** 手机验证码 */
    @NotBlank(message = "请填写手机验证码")
    @Pattern(regexp = "^[0-9]{6}$" , message = "手机验证码错误")
    private String smsCode;

    /**
     * 银行所在省份Code
     */
    private String provinceCode;

    /**
     * 银行所在省份名称
     */
    private String provinceName;

    /**
     * 银行所在市Code
     */
    private String cityCode;

    /**
     * 银行所在市名称
     */
    private String cityName;

    /**
     * 银行支行名称
     */
    private String bankBranchName;

    /**
     * 银行支行行号
     */
    private String bankBranchCode;
    /**
     * 身份证
     */
    private String idNo;

}