package com.js.common.model.req;

import com.js.common.enums.HolType;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

@Data
public class JsSystemHolidayReq implements Serializable {
    private static final long serialVersionUID = 3972983569559877049L;
    private String id;
    /**
     * 节假日日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date holDate;

    /**
     * 类型：HOLIDAYS 节假日 WORKING_DAYS 工作日
     */
    private HolType holType;

    /**
     * 描述
     */
    private String holDesc;

    /**
     * 备用字段1
     */
    private String backup1;

    /**
     * 备用字段2
     */
    private String backup2;

    int pageIndex = 0;
    int pageSize = 10;
}