package com.js.common.model.req;

import com.js.common.enums.ProcessStatusEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySunrateBankTradeInReq implements Serializable {
    private static final long serialVersionUID = -1513703756018851418L;
    /**
     * 入账通知编号
     */
    @NotBlank(message = "入账通知编号不能为空")
    private String transinNoticeId;

    /**
     * 组织结构代码
     */
    @NotBlank(message = "组织结构代码不能为空")
    private String orgCode;

    /**
     * 店铺ID(电商收款账户)
     */
    @NotBlank(message = "店铺ID不能为空")
    private String subAcctNo;

    /**
     * 入账币种
     */
    @NotBlank(message = "入账币种不能为空")
    private String transinCur;

    /**
     * 入账金额
     */
    @NotNull(message = "入账金额不能为空")
    private BigDecimal transinAmt;

    /**
     * 可用金额
     */
    @NotNull(message = "可用金额不能为空")
    private BigDecimal availableAmt;

    /**
     * 入账日期
     */
    @NotNull(message = "入账日期不能为空")
    private Date sysTxnDate;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空")
    private String bankCardNo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;
    /**
     * 交易模式
     */
    private String txnMode;

    private ProcessStatusEnum processStatusEnum;

    private String id;

    private Date createDts;
}