package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class JsPaySunrateBankReq implements Serializable {
    private static final long serialVersionUID = 740200656286234592L;
    /**
     * 组织机构代码
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 店铺ID
     */
    @NotBlank(message = "店铺ID不能为空")
    private String subAcctNo;

    /**
     * 收款银行所在地区（地区国家代码，如：HK、CN、JP。ISO 3166-1 alpha-2）
     */
    @NotBlank(message = "收款银行所在地区不能为空")
    private String bankCountryCode;

    /**
     * 收款银行名称
     */
    @NotBlank(message = "收款银行名称不能为空")
    private String bankName;

    /**
     * 收款银行地址
     */
//    @NotBlank(message = "收款银行地址不能为空")
    private String bankAddr;

    /**
     * 收款银行账户名称
     */
    @NotBlank(message = "收款银行账户名称不能为空")
    private String custName;

    /**
     * 收款银行账号
     */
    @NotBlank(message = "收款银行账号不能为空")
    private String bankCardNo;

    /**
     * 币种(如：USD)
     */
    @NotBlank(message = "币种不能为空")
    private String curId;

    /**
     * 路由方式
     */
    @NotBlank(message = "路由方式不能为空")
    private String routeType;

    /**
     * aba
     */
    private String aba;

    /**
     * iban
     */
    private String iban;

    /**
     * swiftcode
     */
    private String swiftCode;
}