package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class FadadaUploadContractReq implements Serializable {

    private static final long serialVersionUID = 122173851639481470L;

    /**
     * 合同列表
     */
    List<Contract> contracts;

    @Data
    public class Contract implements Serializable {

        private static final long serialVersionUID = 122453851639481470L;

        /**
         * 贷款信息申请 id
         */
        String loanNo;

        /**
         * 合同 id (32位 uuid)
         */
        String contractId;

        /**
         * 合同名称
         */
        String fileName;

        /**
         * 合同的字节数组
         */
        byte[] fileBytes;

    }
}
