package com.js.common.model.vo.common;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author yjzhao
 * @Description 响应VO
 * @Date 2019/5/15 20:09
 * @Param 
 * @return 
 **/
@Builder
@Data
public class ResponseMessage<T> implements Serializable {
    private static final long serialVersionUID = 2750101561037661676L;
    //错误码
    private int code;

    //信息描述
    private String msg;

//具体的信息内容

    private T data;

    //是否成功
    private boolean success;

    public ResponseMessage(){
    }

    public ResponseMessage(T data) {
        this.data = data;
    }

    public ResponseMessage(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public ResponseMessage(int code, String msg, T data, boolean success) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.success = success;
    }

    @Override
    public String toString() {
        return "{"+"\""+"code"+"\""+":" + code + ", "+"\""+"data"+"\""+":" + data + ","+"\""+ "msg"+"\"" +":" +"\""+ msg +"\"" + ", "+"\""+"success"+"\""+":" + success + "}";
    }

}
