package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class KycSunrateStoreVO implements Serializable {

    private String id;
    /**
     * 注册表主键ID
     */
    private String kycNaturalId;

    /**
     * 店铺表主键ID
     */
    private String kycStoreId;

    /**
     * 组织机构代码-识别客户
     */
    private String orgCode;

    /**
     * 店铺所在站点（美国站 USD，日本站 JPY，欧洲站 EUR，英国站 GB）
     */
    private String curId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺网址
     */
    private String storeUrl;

    /**
     * 店铺平台（01 amazon ，02 ebay ，03 yahoo，04 fril  ，05 mercari ）
     */
    private String storePlateform;

    /**
     * 卖家ID
     */
    private String sellerId;

    /**
     * AWS 访问 Key(AKIAJJSMHVJAFRKNERIA)
     */
    private String accessKey;

    /**
     * 私有秘钥（3ZvKcmoEQLDfE9AUX8MRsPGfOzc6m5CGlBnEqhPg）
     */
    private String secretKey;

    /**
     * 销售商品
     */
    private String sellGoods;

    /**
     * 运营时间
     */
    private Date runTime;

    /**
     * 预估月收款总额-单位（万美元）
     */
    private BigDecimal monthAmt;

    /**
     * 店铺ID
     */
    private String subAcctNo;

    /**
     * 审核结果（1-审核通过，2-审核未通过）
     */
    private Integer auditStatus;

    /**
     * 审核备注
     */
    private String auditRemark;

    /**
     * 完成审核时间
     */
    private Date auditDts;
}