package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class SunrateBeneficiaryAuditReq implements Serializable {
    private static final long serialVersionUID = -4620362328976389583L;
    /**
     * 受益人编号-锁汇成交时使用Key，受益人唯一编号
     */
    @NotBlank(message = "受益人编号不能为空")
    private String beneficiaryId;
    /**
     * 组织机构代码
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 受益人状态
     */
    @NotBlank(message = "受益人状态不能为空")
    private String beneficiaryStatus;

    /**
     * 备注
     */
    private String remark;
}