package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class KycSunrateRegisterReq implements Serializable {
    private static final long serialVersionUID = 3400690589471839552L;

    /**
     * 注册人姓名
     */
    @NotBlank(message = "注册人姓名不能为空")
    private String registerName;

    /**
     * 注册邮箱
     */
    @NotBlank(message = "注册人邮箱不能为空")
    private String registerEmail;

    /**
     * 注册手机号
     */
    @NotBlank(message = "注册手机号不能为空")
    private String registerMobile;

    /**
     * 注册类型（1-个人，2-公司）
     */
    @NotNull(message = "注册类型不能为空")
    private Integer registerType;

    /**
     * 名称（个人：姓名，企业：公司名称）
     */
    @NotBlank(message = "名称不能为空")
    private String name;

    /**
     * 组织机构代码（识别客户，本接口文档其他地方出现不再说明，个人：请求方客户 ID 或身份号码，企业：组织结构代码）
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 身份类型（1-法定代表人，2-授权代表人）
     */
    @NotNull(message = "身份类型不能为空")
    private Integer identityType;

    /**
     * 经营地址
     */
    @NotBlank(message = "经营地址不能为空")
    private String openAddress;

    /**
     * 目录路径(资质文件，组织机构号/文件类型，/INPUT/91510100MA6C72JG4D/KYC/ )
     */
    @NotBlank(message = "目录路径不能为空")
    private String dirPath;

    /**
     * 文件列表（Array）
     */
    @NotEmpty(message = "文件列表不能为空")
    private List<String> fileIdList;

    /**
     * 备注-审核结果说明
     */
    private String remark;
}