package com.js.common.model.req;

import com.js.common.enums.CertiFileType;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class KycCertiHKCompanyReq implements Serializable {
    private static final long serialVersionUID = 3680743630482229464L;

    private String id;
    /**
     * 寻汇返回注册编号key
     */
    private String registerId;

    /**
     * 实名表主键ID
     */
    private String kycCertiId;

    /**
     * 企业名称
     */
    @NotBlank(message = "企业名称不能为空")
    private String companyName;

    /**
     * 企业英文名称
     */
    @NotBlank(message = "企业英文名称不能为空")
    private String companyEngName;

    /**
     * 公司注册证书编号
     */
    @NotBlank(message = "公司注册证书编码不能为空")
    @Length(min = 6,max = 18,message = "公司注册证书编码格式不正确")
    private String companyRegisteredCertificateNo;

    /**
     * 企业性质ID
     */
    @NotBlank(message = "企业性质ID不能为空")
    private String companyNatureId;
    /**
     * 企业性质
     */
    @NotBlank(message = "企业性质不能为空")
    private String companyNature;

    /**
     * 企业经营地址
     */
    @NotBlank(message = "企业经营地址不能为空")
    private String companyAddress;

    /**
     * 店铺主要经营类别表ID
     */
    @NotBlank(message = "店铺主要经营类别ID不能为空")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @NotBlank(message = "店铺主要经营类别名称不能为空")
    private String storeBusinessTypeName;

    /**
     * 证件类型编码
     */
    @NotNull(message = "证件类型CODE不能为空")
    private CertiFileType certiCardType;

    /**
     * 董事姓名
     */
    @NotBlank(message = "董事姓名不能为空")
    private String directorName;

    /**
     * 董事证件号
     */
    @NotBlank(message = "董事证件号不能为空")
    private String directorIdNo;

    /**
     * 董事住址
     */
    private String directorAddress;

    /**
     * 身份证有效起始日期
     */
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    private Boolean longFlag;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;

    /**
     * 附件集合
     */
    @NotEmpty(message = "请上传附件信息")
    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;
}