package com.js.common.model.req;

import com.js.common.annotation.Phone;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

@Data
public class KycBankDeleteReq implements Serializable {
    private static final long serialVersionUID = -4338274747671397115L;

    /**
     * 银行卡用户名Code
     */
    @NotNull(message = "银行卡Id不能为空.")
    private String bankId;

    /**
     * 银行卡预留手机号
     */
    @NotNull(message = "银行卡预留手机号不能为空.")
    @Phone
    private String phone;

    /** 标识 */
    @NotBlank(message = "请确认标识是否填写.")
    private String markStr;

    /** 手机验证码 */
    @NotBlank(message = "请填写手机验证码")
    @Pattern(regexp = "^[0-9]{6}$" , message = "手机验证码错误")
    private String smsCode;
}