package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @Description: 更改手机号请求对象
 * @Author: liuh
 * @Create: 2019-05-23  15:07
 **/
@Data
public class ChPwdReq implements Serializable {

    /** kyc账户 */
    private String kycNaturalId;

    /**
     * 手机号
     */
    private String phoneNo;

    /** 密码 */
    @NotNull(message = "请填写原始密码.")
    @Pattern(regexp = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,20}$",message = "原始密码格式不正确")
    private String oldPwd;

    /** 密码 */
    @NotNull(message = "请填写新密码.")
    @Pattern(regexp = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,20}$",message = "新密码格式不正确")
    private String newPwd;

    /** 确认密码 */
    @Pattern(regexp = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,20}$",message = "确认密码格式不正确")
    private String confirmPwd;
}
