package com.js.common.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import io.jsonwebtoken.*;
import lombok.extern.slf4j.Slf4j;

import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import java.security.Key;
import java.util.Map;
import java.util.Optional;

/**
 * @ClassName: JjwtUtil
 * @Description: JJWT工具类
 * @Author: yjzhao
 * @Create: 2019-05-28  10:58
 **/
@Slf4j
public class JjwtUtil {
    private static final String SECRET = "uzlk9cxgh5t38syv7nl51n74dbfero09kbuccwjvuzdz5hixpi";
    private static final String TOKEN_PREFIX = "Bearer";

    /**
     * @Author yjzhao
     * @Description 生成 JWT token
     * @Date 2019/5/28 12:12
     * @Param [claimsMap]
     * @return java.lang.String
     **/
    public static String createJWTByObj(Map<String, Object> claimsMap) {
        //添加构成JWT的参数
        try {
            JwtBuilder builder = Jwts.builder().setHeaderParam("typ", "JWT")
                    .setHeaderParam("alg", "HS256")
                    .setClaims(claimsMap)
                    .signWith(getDefultKey());
            //生成JWT
            return builder.compact();
        } catch (Exception e) {
            throw LogicException.le(ResultEnum.UNKNOW_ERROR);
        }


    }

    /**
     * @Author yjzhao
     * @Description 生成请求中 token
     * @Date 2019/5/28 12:15
     * @Param [claims]
     * @return net.sf.json.JSONObject
     **/
    public static JSONObject generateToken(Map<String, Object> claims) {
        String jwtByObj = createJWTByObj(claims);
        JSONObject json = new JSONObject();
        json.put("webToken",TOKEN_PREFIX + " " + jwtByObj);
        json.put("token-type", TOKEN_PREFIX);
        return json;
    }

    /**
     * @Author yjzhao
     * @Description 解析JWT, 获取 request 中 token
     * @Date 2019/5/28 12:13
     * @Param [request]
     * @return java.util.Map<java.lang.String,java.lang.Object>
     **/
    public static Map<String, Object> validateTokenAndGetClaims(HttpServletRequest request) {
        String token = request.getHeader(Constant.HEADER_X_HO_TOKEN);
        if (token == null) {
            return null;
        }
        try {
            Map<String, Object> body = Jwts.parser()
                    .setSigningKey(getDefultKey())
                    .parseClaimsJws(token.replace(TOKEN_PREFIX, ""))
                    .getBody();
            return body;
        } catch (Exception e) {
            throw LogicException.le(ResultEnum.UNKNOW_ERROR);
        }
    }

    public static Optional<String> getTokenValue(String key, HttpServletRequest request) {
        Map<String, Object> tokenMap = validateTokenAndGetClaims(request);
        if (tokenMap == null || !tokenMap.containsKey(key)) {
            return Optional.empty();
        }
        String tokenValue = (String) tokenMap.get(key);
        return Optional.ofNullable(tokenValue);
    }

    /**
     * @Author yjzhao
     * @Description 生成签名
     * @Date 2019/5/28 12:09
     * @Param [secret]
     * @return java.security.Key
     **/
    private static Key getKey(String mySecret, SignatureAlgorithm mySignatureAlgorithm) {
        if (mySignatureAlgorithm == null) {
            mySignatureAlgorithm = SignatureAlgorithm.HS256;
        }
        //生成签名密钥
        if (StrUtil.isEmpty(mySecret)) {
            mySecret = SECRET;
        }
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary(mySecret);
        return new SecretKeySpec(apiKeySecretBytes, mySignatureAlgorithm.getJcaName());
    }

    private static Key getDefultKey() {
        return getKey(null, null);
    }


    public static void main(String[] args) {
        Map<String, Object> claimsMap = Maps.newHashMap();
        claimsMap.put("id", "12345679");
        JSONObject tokenJson = JjwtUtil.generateToken(claimsMap);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("aaaa", "5256");
        jsonObject.putAll(tokenJson);
        log.info("body:{}", jsonObject);

        //Map<String, Object> body = Jwts.parser()
        //        .setSigningKey(getDefultKey())
        //        .parseClaimsJws(jwtByObj)
        //        .getBody();
        //log.info("body:{}", body);



    }
}
