package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class KycSunrateRegisterNoticeReq implements Serializable {
    private static final long serialVersionUID = -780158826828626582L;
    /**
     * 寻汇返回注册编号key
     */
    @NotBlank(message = "注册编号不能为空")
    private String registerId;

    /**
     * 注册人姓名
     */
    @NotBlank(message = "注册人姓名不能为空")
    private String registerName;

    /**
     * 注册邮箱
     */
    @NotBlank(message = "注册邮箱不能为空")
    private String registerEmail;

    /**
     * 注册手机号
     */
    @NotBlank(message = "注册手机号不能为空")
    private String registerMobile;
    /**
     * 注册状态(0:提交未接受审核结果, 1:审核通过，2:审核未通过（驳回，拒绝)
     */
    @NotNull(message = "注册状态不能为空")
    private Integer registerStatus;

    /**
     * 备注-审核结果说明
     */
    private String remark;
}