package com.js.common.model.req;

import com.js.common.enums.BeneficiaryTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class KycSunrateBeneficiaryReq implements Serializable {
    private static final long serialVersionUID = 883855497263143596L;
    /**
     * 受益人编号-锁汇成交时使用Key，受益人唯一编号
     */
    private String beneficiaryId;
    /**
     * 组织机构代码
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 国家代码，受益人国家-如：HK、CN、JP，ISO 3166-1 alpha-2
     */
    @NotBlank(message = "国家代码不能为空")
    private String countryCode;

    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空")
    private String bankName;

    /**
     * 路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift 
     */
    @NotBlank(message = "路由类型不能为空")
    private String routeType;

    /**
     * ABA
     */
    private String aba;

    /**
     * IBAN
     */
    private String iban;

    /**
     * SWIFTCODE
     */
    private String swiftcode;

    /**
     * 受益人名称
     */
    @NotBlank(message = "受益人名称不能为空")
    private String beneficiaryName;

    /**
     * 受益人银行账号，iban 包含账号，此处也需要
     */
    @NotBlank(message = "受益人账户号码不能为空")
    private String beneficiaryAcctNo;

    /**
     * 币种
     */
    @NotBlank(message = "币种不能为空")
    private String cur;

    /**
     * 受益人地址
     */
    @NotBlank(message = "受益人地址不能为空")
    private String beneficiaryAddr;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空")
    private String remark;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;

    /**
     * 收益人类型
     */
    @NotBlank(message = "收益人类型不能为空")
    private BeneficiaryTypeEnum beneficiaryType;

    int pageIndex = 0;
    int pageSize = 10;

    private String kycNaturalId;
}