package com.js.common.model.req;

import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.SexEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter
public class KycNaturalReq implements Serializable {
    private static final long serialVersionUID = 1L;

    /** id */
    private String id;
    /**
     * 注册类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）
     */
    private RegisterType registerType;

    /**
     * 实名名称（类型为个人填写客户姓名，类型为企业填写企业名称）
     */
    private String certificationName;

    private String idNo;

    /**
     * 注册手机号
     */
    private String phoneNo;

    private SexEnum sex;

    /**
     * 注册邮箱
     */
    private String email;

    /**
     * 邮箱是否激活(0:未激活, 1:已激活)
     */
    private Boolean emailActiveFlag;

    /**
     * 实名认证状态
     */
    private CertiStatusEnum certificationStatus;

    /**
     * 邀请码
     */
    private String inviteCode;

    /** 是否删除[0:不删除, 1:删除] */
    private Boolean delFlag;

    /** 是否通过经营者备案[1是，0否] */
    private Boolean recordFlag;

    /**
     * 驳回原因
     */
    private String jsRemark;

}