package com.js.common.model.req;

import com.js.common.enums.CertiFileType;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CertiMainLandPersonalReq implements Serializable {
    private static final long serialVersionUID = -14419194479874941L;

    private String id;

    /**
     * 寻汇返回注册编号key
     */
    private String registerId;
    /**
     * 实名表主键ID
     */
    private String kycCertiId;

    /**
     * 证件类型编码
     */
    @NotNull(message = "证件类型CODE不能为空")
    private CertiFileType certiCardType;

    /**
     * 附件集合
     */
    @NotEmpty(message = "请上传附件信息")
    @Size(min = 3,max = 3,message = "大陆个人影像附件应为三张")
    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;

    /**
     * 客户真实姓名
     */
    @NotNull(message = "客户真实姓名不能为空")
    private String cusName;

    /**
     * 客户英文名称
     */
    @NotNull(message = "客户英文名称不能为空")
    private String cusEngName;

    /**
     * 个人住址
     */
    @NotNull(message = "个人住址不能为空")
    private String liveAddress;

    /**
     * 身份证号
     */
    @NotBlank(message = "客户身份证号不能为空")
    @Pattern(regexp = "^[1-9]\\d{5}(18|19|2([0-9]))\\d{2}(0[0-9]|10|11|12)(0[1-9]|[1-2][0-9]|30|31)\\d{3}[0-9Xx]$" , message = "身份证格式不正确")
    private String idNo;

    /**
     * 身份证有效起始日期
     */
    @NotNull(message = "身份证有效起始日期不能为空")
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    private Date effectiveEndTime;

    /**
     * 是否长期有效(false-0:非长期，true-1：长期)
     */
    @NotNull(message = "证件是否长期有效必须勾选")
    private Boolean longFlag;

    /**
     * 店铺主要经营类别表ID
     */
    @NotBlank(message = "店铺主要经营类别ID不能为空")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @NotBlank(message = "店铺主要经营类别不能为空")
    private String storeBusinessTypeName;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;
}