package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 平台账户类型
 * @Author: liuh
 * @Create: 2019-06-14
 **/
@Getter
public enum PayAccountTypeEnum {
    HFGJ_YFJS_ACCT("1001", "汇付国际-源奉济生大账户类型"),
    HFGJ_POUNDAGE_ACCT("1002", "汇付国际-手续费账户类型"),
    HFGJ_RATE_ACCT("1003", "汇付国际-汇差收入账户类型"),
    HFGJ_LOAN_SERVICE_FEE_ACCT("1004", "汇付国际-贷款服务费账户类型"),
    ;
    private String code;
    private String desc;
    PayAccountTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
