package com.js.common.enums;

/**
 * 身份证地区信息码表
 *
 * 拷贝自 https://blog.csdn.net/weixin_43203897/article/details/90023533
 * 去掉了一些省与洲的后缀。如果使用过程中发现缺失编码再手动添加
 */
public enum IdCardAreaCodeEnum {
    BEIJING_BEIJING("1100", "北京", "北京"),
    TIANJIN_TIANJIN("1200", "天津", "天津"),
    HEBEI_SHIJIAZHUANG("1301", "河北", "石家庄"),
    HEBEI_TANGSHAN("1302", "河北", "唐山"),
    HEBEI_QINHUANGDAO("1303", "河北", "秦皇岛"),
    HEBEI_HANDAN("1304", "河北", "邯郸"),
    HEBEI_XINGTAI("1305", "河北", "邢台"),
    HEBEI_BAODING("1306", "河北", "保定"),
    HEBEI_ZHANGJIAKOU("1307", "河北", "张家口"),
    HEBEI_CHENGDE("1308", "河北", "承德"),
    HEBEI_CANGZHOU("1309", "河北", "沧州"),
    HEBEI_LANGFANG("1310", "河北", "廊坊"),
    HEBEI_HENGSHUI("1311", "河北", "衡水"),
    SHANXI_TAIYUAN("1401", "山西", "太原"),
    SHANXI_DATONG("1402", "山西", "大同"),
    SHANXI_YANGQUAN("1403", "山西", "阳泉"),
    SHANXI_ZHANGZHI("1404", "山西", "长治"),
    SHANXI_JINCHENG("1405", "山西", "晋城"),
    SHANXI_SHUOZHOU("1406", "山西", "朔州"),
    SHANXI_JINZHONG("1407", "山西", "晋中"),
    SHANXI_YUNCHENG("1408", "山西", "运城"),
    SHANXI_XINZHOU("1409", "山西", "忻州"),
    SHANXI_LINFEN("1410", "山西", "临汾"),
    SHANXI_LVLIANG("1411", "山西", "吕梁"),
    SHANXI_JINZHONG2("1424", "山西", "晋中"),
    NEIMENGGU_HUHEHAOTE("1501", "内蒙古", "呼和浩特"),
    NEIMENGGU_BAOTOU("1502", "内蒙古", "包头"),
    NEIMENGGU_WUHAI("1503", "内蒙古", "乌海"),
    NEIMENGGU_CHIFENG("1504", "内蒙古", "赤峰"),
    NEIMENGGU_TONGLIAO("1505", "内蒙古", "通辽"),
    NEIMENGGU_EERDUOSI("1506", "内蒙古", "鄂尔多斯"),
    NEIMENGGU_HULUNBEIER("1507", "内蒙古", "呼伦贝尔"),
    NEIMENGGU_BAYANNAOER("1508", "内蒙古", "巴彦淖尔"),
    NEIMENGGU_WULANCHABU("1509", "内蒙古", "乌兰察布"),
    NEIMENGGU_XINGANMENG("1522", "内蒙古", "兴安盟"),
    NEIMENGGU_XILINGUOLE("1525", "内蒙古", "锡林郭勒"),
    NEIMENGGU_WULANCHABU2("1526", "内蒙古", "乌兰察布"),
    NEIMENGGU_ALASHANMENG("1529", "内蒙古", "阿拉善盟"),
    LIAONING_SHENYANG("2101", "辽宁", "沈阳"),
    LIAONING_DALIAN("2102", "辽宁", "大连"),
    LIAONING_ANSHAN("2103", "辽宁", "鞍山"),
    LIAONING_FUSHUN("2104", "辽宁", "抚顺"),
    LIAONING_BENXI("2105", "辽宁", "本溪"),
    LIAONING_DANDONG("2106", "辽宁", "丹东"),
    LIAONING_JINZHOU("2107", "辽宁", "锦州"),
    LIAONING_YINGKOU("2108", "辽宁", "营口"),
    LIAONING_FUXIN("2109", "辽宁", "阜新"),
    LIAONING_LIAOYANG("2110", "辽宁", "辽阳"),
    LIAONING_PANJIN("2111", "辽宁", "盘锦"),
    LIAONING_TIELING("2112", "辽宁", "铁岭"),
    LIAONING_ZHAOYANG("2113", "辽宁", "朝阳"),
    LIAONING_HULUDAO("2114", "辽宁", "葫芦岛"),
    JILIN_JILIN("2200", "吉林", "吉林"),
    JILIN_CHANGCHUN("2201", "吉林", "长春"),
    JILIN_JILIN2("2202", "吉林", "吉林"),
    JILIN_SIPING("2203", "吉林", "四平"),
    JILIN_LIAOYUAN("2204", "吉林", "辽源"),
    JILIN_TONGHUA("2205", "吉林", "通化"),
    JILIN_BAISHAN("2206", "吉林", "白山"),
    JILIN_SONGYUAN("2207", "吉林", "松原"),
    JILIN_BAICHENG("2208", "吉林", "白城"),
    JILIN_YANBIANZHOU("2224", "吉林", "延边州"),
    HEILONGJIANG_HAERBIN("2301", "黑龙江", "哈尔滨"),
    HEILONGJIANG_QIQIHAER("2302", "黑龙江", "齐齐哈尔"),
    HEILONGJIANG_JIXI("2303", "黑龙江", "鸡西"),
    HEILONGJIANG_HEGANG("2304", "黑龙江", "鹤岗"),
    HEILONGJIANG_SHUANGYASHAN("2305", "黑龙江", "双鸭山"),
    HEILONGJIANG_DAQING("2306", "黑龙江", "大庆"),
    HEILONGJIANG_YICHUN("2307", "黑龙江", "伊春"),
    HEILONGJIANG_JIAMUSI("2308", "黑龙江", "佳木斯"),
    HEILONGJIANG_QITAIHE("2309", "黑龙江", "七台河"),
    HEILONGJIANG_MUDANJIANG("2310", "黑龙江", "牡丹江"),
    HEILONGJIANG_HEIHE("2311", "黑龙江", "黑河"),
    HEILONGJIANG_SUIHUA("2312", "黑龙江", "绥化"),
    HEILONGJIANG_HAERBIN2("2321", "黑龙江", "哈尔滨"),
    HEILONGJIANG_DAXINGANLING("2327", "黑龙江", "大兴安岭"),
    SHANGHAI_SHANGHAI("3100", "上海", "上海"),
    JIANGSU_NANJING("3201", "江苏", "南京"),
    JIANGSU_WUXI("3202", "江苏", "无锡"),
    JIANGSU_XUZHOU("3203", "江苏", "徐州"),
    JIANGSU_CHANGZHOU("3204", "江苏", "常州"),
    JIANGSU_SUZHOU("3205", "江苏", "苏州"),
    JIANGSU_NANTONG("3206", "江苏", "南通"),
    JIANGSU_LIANYUNGANG("3207", "江苏", "连云港"),
    JIANGSU_HUAIAN("3208", "江苏", "淮安"),
    JIANGSU_YANCHENG("3209", "江苏", "盐城"),
    JIANGSU_YANGZHOU("3210", "江苏", "扬州"),
    JIANGSU_ZHENJIANG("3211", "江苏", "镇江"),
    JIANGSU_TAIZHOU("3212", "江苏", "泰州"),
    ZHEJIANGSHENG_HANGZHOU("3301", "浙江", "杭州"),
    ZHEJIANGSHENG_NINGBO("3302", "浙江", "宁波"),
    ZHEJIANGSHENG_WENZHOU("3303", "浙江", "温州"),
    ZHEJIANGSHENG_JIAXING("3304", "浙江", "嘉兴"),
    ZHEJIANGSHENG_HUZHOU("3305", "浙江", "湖州"),
    ZHEJIANGSHENG_SHAOXING("3306", "浙江", "绍兴"),
    ZHEJIANGSHENG_JINHUA("3307", "浙江", "金华"),
    ZHEJIANGSHENG_QUZHOU("3308", "浙江", "衢州"),
    ZHEJIANGSHENG_ZHOUSHAN("3309", "浙江", "舟山"),
    ZHEJIANGSHENG_TAIZHOU("3310", "浙江", "台州"),
    ZHEJIANGSHENG_LISHUI("3311", "浙江", "丽水"),
    ANHUI_HEFEI("3401", "安徽", "合肥"),
    ANHUI_WUHU("3402", "安徽", "芜湖"),
    ANHUI_BENGBU("3403", "安徽", "蚌埠"),
    ANHUI_HUAINAN("3404", "安徽", "淮南"),
    ANHUI_MAANSHAN("3405", "安徽", "马鞍山"),
    ANHUI_HUAIBEI("3406", "安徽", "淮北"),
    ANHUI_TONGLING("3407", "安徽", "铜陵"),
    ANHUI_ANQING("3408", "安徽", "安庆"),
    ANHUI_HUANGSHAN("3410", "安徽", "黄山"),
    ANHUI_CHUZHOU("3411", "安徽", "滁州"),
    ANHUI_FUYANG("3412", "安徽", "阜阳"),
    ANHUI_SUZHOU("3413", "安徽", "宿州"),
    ANHUI_LUAN("3415", "安徽", "六安"),
    ANHUI_BOZHOU("3416", "安徽", "亳州"),
    ANHUI_CHIZHOU("3417", "安徽", "池州"),
    ANHUI_XUANCHENG("3418", "安徽", "宣城"),
    ANHUI_SUXIAN("3422", "安徽", "宿县"),
    FUJIAN_FUZHOU("3501", "福建", "福州"),
    FUJIAN_XIAMEN("3502", "福建", "厦门"),
    FUJIAN_PUTIAN("3503", "福建", "莆田"),
    FUJIAN_SANMING("3504", "福建", "三明"),
    FUJIAN_QUANZHOU("3505", "福建", "泉州"),
    FUJIAN_ZHANGZHOU("3506", "福建", "漳州"),
    FUJIAN_NANPING("3507", "福建", "南平"),
    FUJIAN_LONGYAN("3508", "福建", "龙岩"),
    FUJIAN_NINGDE("3509", "福建", "宁德"),
    JIANGXI_NANCHANG("3601", "江西", "南昌"),
    JIANGXI_JINGDEZHEN("3602", "江西", "景德镇"),
    JIANGXI_PINGXIANG("3603", "江西", "萍乡"),
    JIANGXI_JIUJIANG("3604", "江西", "九江"),
    JIANGXI_XINYU("3605", "江西", "新余"),
    JIANGXI_YINGTAN("3606", "江西", "鹰潭"),
    JIANGXI_GANZHOU("3607", "江西", "赣州"),
    JIANGXI_JIAN("3608", "江西", "吉安"),
    JIANGXI_YICHUN("3609", "江西", "宜春"),
    JIANGXI_FUZHOU("3610", "江西", "抚州"),
    JIANGXI_SHANGRAO("3611", "江西", "上饶"),
    SHANDONG_JINAN("3701", "山东", "济南"),
    SHANDONG_QINGDAO("3702", "山东", "青岛"),
    SHANDONG_ZIBO("3703", "山东", "淄博"),
    SHANDONG_ZAOZHUANG("3704", "山东", "枣庄"),
    SHANDONG_DONGYING("3705", "山东", "东营"),
    SHANDONG_YANTAI("3706", "山东", "烟台"),
    SHANDONG_WEIFANG("3707", "山东", "潍坊"),
    SHANDONG_JINING("3708", "山东", "济宁"),
    SHANDONG_TAIAN("3709", "山东", "泰安"),
    SHANDONG_WEIHAI("3710", "山东", "威海"),
    SHANDONG_RIZHAO("3711", "山东", "日照"),
    SHANDONG_LAIWU("3712", "山东", "莱芜"),
    SHANDONG_LINYI("3713", "山东", "临沂"),
    SHANDONG_DEZHOU("3714", "山东", "德州"),
    SHANDONG_LIAOCHENG("3715", "山东", "聊城"),
    SHANDONG_BINZHOU("3716", "山东", "滨州"),
    SHANDONG_HEZE("3717", "山东", "菏泽"),
    HENAN_ZHENGZHOU("4101", "河南", "郑州"),
    HENAN_KAIFENG("4102", "河南", "开封"),
    HENAN_LUOYANG("4103", "河南", "洛阳"),
    HENAN_PINGDINGSHAN("4104", "河南", "平顶山"),
    HENAN_ANYANG("4105", "河南", "安阳"),
    HENAN_HEBI("4106", "河南", "鹤壁"),
    HENAN_XINXIANG("4107", "河南", "新乡"),
    HENAN_JIAOZUO("4108", "河南", "焦作"),
    HENAN_PUYANG("4109", "河南", "濮阳"),
    HENAN_XUCHANG("4110", "河南", "许昌"),
    HENAN_TAHE("4111", "河南", "漯河"),
    HENAN_SANMENXIA("4112", "河南", "三门峡"),
    HENAN_NANYANG("4113", "河南", "南阳"),
    HENAN_SHANGQIU("4114", "河南", "商丘"),
    HENAN_XINYANG("4115", "河南", "信阳"),
    HENAN_ZHOUKOU("4116", "河南", "周口"),
    HENAN_ZHUMADIAN("4117", "河南", "驻马店"),
    HUBEI_WUHAN("4201", "湖北", "武汉"),
    HUBEI_HUANGSHI("4202", "湖北", "黄石"),
    HUBEI_SHIYAN("4203", "湖北", "十堰"),
    HUBEI_YICHANG("4205", "湖北", "宜昌"),
    HUBEI_XIANGYANG("4206", "湖北", "襄阳"),
    HUBEI_EZHOU("4207", "湖北", "鄂州"),
    HUBEI_JINGMEN("4208", "湖北", "荆门"),
    HUBEI_XIAOGAN("4209", "湖北", "孝感"),
    HUBEI_JINGZHOU("4210", "湖北", "荆州"),
    HUBEI_HUANGGANG("4211", "湖北", "黄冈"),
    HUBEI_XIANNING("4212", "湖北", "咸宁"),
    HUBEI_SUIZHOU("4213", "湖北", "随州"),
    HUBEI_ENSHIZHOU("4228", "湖北", "恩施州"),
    HUNAN_ZHANGSHA("4301", "湖南", "长沙"),
    HUNAN_ZHUZHOU("4302", "湖南", "株洲"),
    HUNAN_XIANGTAN("4303", "湖南", "湘潭"),
    HUNAN_HENGYANG("4304", "湖南", "衡阳"),
    HUNAN_SHAOYANG("4305", "湖南", "邵阳"),
    HUNAN_YUEYANG("4306", "湖南", "岳阳"),
    HUNAN_CHANGDE("4307", "湖南", "常德"),
    HUNAN_YIYANG("4309", "湖南", "益阳"),
    HUNAN_CHENZHOU("4310", "湖南", "郴州"),
    HUNAN_YONGZHOU("4311", "湖南", "永州"),
    HUNAN_HUAIHUA("4312", "湖南", "怀化"),
    HUNAN_LOUDI("4313", "湖南", "娄底"),
    HUNAN_XIANGXIZHOU("4331", "湖南", "湘西州"),
    GUANGDONG_GUANGZHOU("4401", "广东", "广州"),
    GUANGDONG_SHAOGUAN("4402", "广东", "韶关"),
    GUANGDONG_SHENZHEN("4403", "广东", "深圳"),
    GUANGDONG_ZHUHAI("4404", "广东", "珠海"),
    GUANGDONG_SHANTOU("4405", "广东", "汕头"),
    GUANGDONG_FOSHAN("4406", "广东", "佛山"),
    GUANGDONG_JIANGMEN("4407", "广东", "江门"),
    GUANGDONG_ZHANJIANG("4408", "广东", "湛江"),
    GUANGDONG_MAOMING("4409", "广东", "茂名"),
    GUANGDONG_ZHAOQING("4412", "广东", "肇庆"),
    GUANGDONG_HUIZHOU("4413", "广东", "惠州"),
    GUANGDONG_MEIZHOU("4414", "广东", "梅州"),
    GUANGDONG_SHANWEI("4415", "广东", "汕尾"),
    GUANGDONG_HEYUAN("4416", "广东", "河源"),
    GUANGDONG_YANGJIANG("4417", "广东", "阳江"),
    GUANGDONG_QINGYUAN("4418", "广东", "清远"),
    GUANGDONG_DONGGUAN("4419", "广东", "东莞"),
    GUANGDONG_ZHONGSHAN("4420", "广东", "中山"),
    GUANGDONG_CHAOZHOU("4451", "广东", "潮州"),
    GUANGDONG_JIEYANG("4452", "广东", "揭阳"),
    GUANGDONG_YUNFU("4453", "广东", "云浮"),
    GUANGXI_NANNING("4501", "广西", "南宁"),
    GUANGXI_LIUZHOU("4502", "广西", "柳州"),
    GUANGXI_GUILIN("4503", "广西", "桂林"),
    GUANGXI_WUZHOU("4504", "广西", "梧州"),
    GUANGXI_BEIHAI("4505", "广西", "北海"),
    GUANGXI_FANGCHENGGANG("4506", "广西", "防城港"),
    GUANGXI_QINZHOU("4507", "广西", "钦州"),
    GUANGXI_GUIGANG("4508", "广西", "贵港"),
    GUANGXI_YULIN("4509", "广西", "玉林"),
    GUANGXI_BAISE("4510", "广西", "百色"),
    GUANGXI_HEZHOU("4511", "广西", "贺州"),
    GUANGXI_HECHI("4512", "广西", "河池"),
    GUANGXI_LAIBIN("4513", "广西", "来宾"),
    GUANGXI_CHONGZUO("4514", "广西", "崇左"),
    GUANGXI_HEZHOU2("4524", "广西", "贺州"),
    HAINAN_HAIKOU("4601", "海南", "海口"),
    HAINAN_SANYA("4602", "海南", "三亚"),
    HAINAN_DANZHOU("4690", "海南", "儋州"),
    HAINAN_SANSHA("4690", "海南", "三沙"),
    CHONGQING_CHONGQING("5000", "重庆", "重庆"),
    SICHUAN_CHENGDU("5101", "四川", "成都"),
    SICHUAN_ZIGONG("5103", "四川", "自贡"),
    SICHUAN_PANZHIHUA("5104", "四川", "攀枝花"),
    SICHUAN_LUZHOU("5105", "四川", "泸州"),
    SICHUAN_DEYANG("5106", "四川", "德阳"),
    SICHUAN_MIANYANG("5107", "四川", "绵阳"),
    SICHUAN_GUANGYUAN("5108", "四川", "广元"),
    SICHUAN_SUINING("5109", "四川", "遂宁"),
    SICHUAN_NEIJIANG("5110", "四川", "内江"),
    SICHUAN_LESHAN("5111", "四川", "乐山"),
    SICHUAN_NANCHONG("5113", "四川", "南充"),
    SICHUAN_MEISHAN("5114", "四川", "眉山"),
    SICHUAN_YIBIN("5115", "四川", "宜宾"),
    SICHUAN_GUANGAN("5116", "四川", "广安"),
    SICHUAN_DAZHOU("5117", "四川", "达州"),
    SICHUAN_BAZHONG("5119", "四川", "巴中"),
    SICHUAN_ZIYANG("5120", "四川", "资阳"),
    SICHUAN_LIANGSHANZHOU("5134", "四川", "凉山州"),
    GUIZHOU_GUIYANG("5201", "贵州", "贵阳"),
    GUIZHOU_LIUPANSHUI("5202", "贵州", "六盘水"),
    GUIZHOU_ZUNYI("5203", "贵州", "遵义"),
    GUIZHOU_ANSHUN("5204", "贵州", "安顺"),
    GUIZHOU_BIJIE("5205", "贵州", "毕节"),
    GUIZHOU_TONGREN("5206", "贵州", "铜仁"),
    GUIZHOU_QIANXINANZHOU("5223", "贵州", "黔西南州"),
    GUIZHOU_QIANDONGNANZHOU("5226", "贵州", "黔东南州"),
    GUIZHOU_QIANNANZHOU("5227", "贵州", "黔南州"),
    YUNNAN_KUNMING("5301", "云南", "昆明"),
    YUNNAN_QUJING("5303", "云南", "曲靖"),
    YUNNAN_YUXI("5304", "云南", "玉溪"),
    YUNNAN_BAOSHAN("5305", "云南", "保山"),
    YUNNAN_ZHAOTONG("5306", "云南", "昭通"),
    YUNNAN_LIJIANG("5307", "云南", "丽江"),
    YUNNAN_PUER("5308", "云南", "普洱"),
    YUNNAN_LINCANG("5309", "云南", "临沧"),
    YUNNAN_CHUXIONGZHOU("5323", "云南", "楚雄州"),
    YUNNAN_HONGHEZHOU("5325", "云南", "红河州"),
    YUNNAN_WENSHANZHOU("5326", "云南", "文山州"),
    YUNNAN_XISHUANGBANNA("5328", "云南", "西双版纳"),
    YUNNAN_DALIZHOU("5329", "云南", "大理州"),
    YUNNAN_DEHONGZHOU("5331", "云南", "德宏州"),
    YUNNAN_NUJIANGZHOU("5333", "云南", "怒江州"),
    YUNNAN_DIQINGZHOU("5334", "云南", "迪庆州"),
    XIZANG_LASA("5401", "西藏", "拉萨"),
    XIZANG_CHANGDOU("5421", "西藏", "昌都"),
    XIZANG_SHANNAN("5422", "西藏", "山南"),
    XIZANG_RIKAZE("5423", "西藏", "日喀则"),
    XIZANG_LINZHI("5426", "西藏", "林芝"),
    SHANXI_XIAN("6101", "陕西", "西安"),
    SHANXI_TONGCHUAN("6102", "陕西", "铜川"),
    SHANXI_BAOJI("6103", "陕西", "宝鸡"),
    SHANXI_XIANYANG("6104", "陕西", "咸阳"),
    SHANXI_WEINAN("6105", "陕西", "渭南"),
    SHANXI_YANAN("6106", "陕西", "延安"),
    SHANXI_HANZHONG("6107", "陕西", "汉中"),
    SHANXI_YULIN("6108", "陕西", "榆林"),
    SHANXI_ANKANG("6109", "陕西", "安康"),
    SHANXI_SHANGLUO("6110", "陕西", "商洛"),
    GANSUSHENG_LANZHOU("6201", "甘肃", "兰州"),
    GANSUSHENG_JIAYUGUAN("6202", "甘肃", "嘉峪关"),
    GANSUSHENG_JINCHANG("6203", "甘肃", "金昌"),
    GANSUSHENG_BAIYIN("6204", "甘肃", "白银"),
    GANSUSHENG_TIANSHUI("6205", "甘肃", "天水"),
    GANSUSHENG_WUWEI("6206", "甘肃", "武威"),
    GANSUSHENG_ZHANGYE("6207", "甘肃", "张掖"),
    GANSUSHENG_PINGLIANG("6208", "甘肃", "平凉"),
    GANSUSHENG_JIUQUAN("6209", "甘肃", "酒泉"),
    GANSUSHENG_QINGYANG("6210", "甘肃", "庆阳"),
    GANSUSHENG_DINGXI("6211", "甘肃", "定西"),
    GANSUSHENG_LONGNAN("6212", "甘肃", "陇南"),
    GANSUSHENG_LINXIAZHOU("6229", "甘肃", "临夏州"),
    GANSUSHENG_GANNANZHOU("6230", "甘肃", "甘南州"),
    QINGHAI_XINING("6301", "青海", "西宁"),
    QINGHAI_HAIDONG("6321", "青海", "海东"),
    QINGHAI_HAIBEIZHOU("6322", "青海", "海北州"),
    QINGHAI_HUANGNANZHOU("6323", "青海", "黄南州"),
    QINGHAI_HAINANZHOU("6325", "青海", "海南州"),
    QINGHAI_GUOLUOZHOU("6326", "青海", "果洛州"),
    QINGHAI_YUSHUZHOU("6327", "青海", "玉树州"),
    QINGHAI_HAIXIZHOU("6328", "青海", "海西州"),
    NINGXIA_YINCHUAN("6401", "宁夏", "银川"),
    NINGXIA_SHIZUISHAN("6402", "宁夏", "石嘴山"),
    NINGXIA_WUZHONG("6403", "宁夏", "吴忠"),
    NINGXIA_GUYUAN("6404", "宁夏", "固原"),
    NINGXIA_ZHONGWEI("6405", "宁夏", "中卫"),
    XINJIANG_WULUMUQI("6501", "新疆", "乌鲁木齐"),
    XINJIANG_KELAMAYI("6502", "新疆", "克拉玛依"),
    XINJIANG_TULUFAN("6521", "新疆", "吐鲁番"),
    XINJIANG_HAMI("6522", "新疆", "哈密"),
    XINJIANG_CHANGJIZHOU("6523", "新疆", "昌吉州"),
    XINJIANG_BOERTALAZHOU("6527", "新疆", "博尔塔拉州"),
    XINJIANG_BAYINGUOLENG("6528", "新疆", "巴音郭楞"),
    XINJIANG_KEZILESUZHOU("6530", "新疆", "克孜勒苏州"),
    XINJIANG_KASHIDIQU("6531", "新疆", "喀什地区"),
    XINJIANG_HETIANDIQU("6532", "新疆", "和田地区"),
    XINJIANG_YILIZHOU("6540", "新疆", "伊犁州"),
    XINJIANG_TACHENGDIQU("6542", "新疆", "塔城地区"),
    XINJIANG_SHIHEZI("6590", "新疆", "石河子")
    ;

    IdCardAreaCodeEnum(String code, String province, String city) {
        this.code = code;
        this.province = province;
        this.city = city;
    }

    final String code;
    final String province;
    final String city;

    public String getCode() {
        return code;
    }

    public String getProvince() {
        return province;
    }

    public String getCity() {
        return city;
    }

    public static IdCardAreaCodeEnum getArea(String code) {
        for (IdCardAreaCodeEnum value : IdCardAreaCodeEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
