package com.js.common.model.vo;

import com.js.common.enums.SiteEnum;
import com.js.common.enums.StorePlateformEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class KycShowApplyVO implements Serializable {
    private static final long serialVersionUID = -2361304917881698964L;

    /**
     * 询价结果
     */
    private boolean queryPriceFlag;

    /**
     * 币种
     */
    private String currency;

    /**
     * 币种
     */
    private String currencySymbol;

    /**
     * 站点
     */
    private SiteEnum siteName;

    /**
     * 平台
     */
    private StorePlateformEnum storePlateform;

    /**
     * 平台 + 站点
     */
    private String plateformAndSite;

    /**
     * 已申请账户数
     */
    private Integer applyAccountNum;
    /**
     * 账户总额
     */
    private BigDecimal accountTotalAmt;
    /**
     * 账户人民币总额
     */
    private BigDecimal accountCNYTotalAmt;
}