package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


@Data
public class JsPaySupplierCNYVO<T> extends JsPaySupplierVO {
    /**
     * 收款方银行所在地（地区国家代码，如：HK、CN、JP）
     */
    private String rcvBankCountry;
    /**
     * 收款方银行卡号
     */
    private String rcvBankCard;
    /**
     * 开户省份
     */
    private String rcvBankProvince;
    /**
     * 开户城市
     */
    private String rcvBankCity;
    /**
     * 收款银行开户支行名称
     */
    private String rcvBankSubbranch;
    /**
     * 收款方证件号
     */
    private String rcvCreditCode;
    /**
     * 收款方联系电话
     */
    private String rcvPhone;
    /**
     * 贸易类型
     */
    private String tradeType;

    @Override
    public String toString(){
        return  super.toString()+ "rcvBankCard|rcvBankName|rcvBankProvince|rcvBankCity|rcvBankSubbranch|rcvCreditCode|rcvPhone" + endString() + "|tradeType" ;
    }
}
