package com.js.common.model.vo;

import com.js.common.enums.ProcessStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySunrateBankTradeInVO implements Serializable {
    private String id;

    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    private String kycSunrateBankId;

    /**
     * 入账通知编号
     */
    private String transinNoticeId;

    /**
     * 组织结构代码
     */
    private String orgCode;

    /**
     * 店铺ID(电商收款账户)
     */
    private String subAcctNo;

    /**
     * 入账币种
     */
    private String transinCur;

    /**
     * 入账金额
     */
    private BigDecimal transinAmt;

    /**
     * 可用金额
     */
    private BigDecimal availableAmt;

    /**
     * 当前余额
     */
    private BigDecimal currentBalance;

    /**
     * 账户可用余额
     */
    private BigDecimal availableBalance;

    /**
     * 入账日期
     */
    private Date sysTxnDate;

    /**
     * 银行卡号
     */
    private String bankCardNo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    private ProcessStatusEnum processStatus;
}