package com.js.common.model.resp;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 资金明细详情
 */
@Data
public class CapitalDetailedDetailsVO implements Serializable {
    private static final long serialVersionUID = -5665391995790310015L;

    /**
     *还款金额
     */
    private BigDecimal total;
    /**
     *本金
     */
    private BigDecimal capital;
    /**
     *利息
     */
    private BigDecimal interest;
    /**
     *费用
     */
    private BigDecimal instFee;
    /**
     * 还款时间
     */
    private Date repayDate;
    /**
     *还款类型
     */
    private String repayType;
    /**
     *还款手续费
     */
    private BigDecimal otherFee;
    /**
     *借款金额
     */
    private BigDecimal loanAmount;
    /**
     *借款时间
     */
    private Date loanDate;
    /**
     *还款方式
     */
    private String repayWay;
    /**
     *交易流水号
     */
    private String capitalNo;
    /**
     * 贷款编号
     */
    private String loanNo;

}
