package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsLoanApplyInfoReq implements Serializable {
    private static final long serialVersionUID = 122173851639481470L;

    /**
     * 贷款申请编号
      */
    private String loanNo;
    /**
     *  KYC注册ID
     */
    @NotBlank(message = "KYC注册ID不能为空")
    private String kycNaturalId;
    /**
     * 意向贷款金额
     */
    @NotNull(message = "申请金额不能为空")
    @Min(value = 0,message = "申请金额不能为0")
    private BigDecimal applyAmt;
    /**
     * 申请贷款时间
     */
    private String applyDate;
    /**
     * 借款天数
     */
    @NotNull(message = "借款天数不能为空")
    @Min(value = 0,message = "借款天数不能为0")
    private Integer loanDays;
    /**
     * 还款方式
     */
    @NotBlank(message = "KYC注册ID不能为空")
    private String repayType;

    /**
     * 产品编号 可空
     */
    private String productNo;
    /**
     * 银行账户名称
     */
    @NotBlank(message = "银行账户名称不能为空")
    private String acctName;
    /**
     * 银行账户号
      */
    @NotBlank(message = "银行账户号不能为空")
    private String acctNo;
    /**
     * 身份证号
     */
    private String certNo;
    /**
     * 银行预留手机号
     */
    @NotBlank(message = "银行预留手机号不能为空")
    private String mobileNo;
    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空")
    private String bankName;
    /**
     * 银行代码
     */
    @NotBlank(message = "银行代码不能为空")
    private String bankCode;

    /**
     * 支行名称 可空
     */
    private String bankBranchName;
    /**
     * 支行省 可空
     */
    private String bankBranchPrivince;
    /**
     * 支行市  可空
     */
    private String bankBranchCity;

    private String riskNo;


}