package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 注册类型
 * @Author: liuh
 * @Create: 2019-05-28
 **/
@Getter
public enum RegisterType {
    NONE_TYPE(0,"暂无类型"),
    MAINLAND_PERSONAL(1, "中国大陆-个人"),
    MAINLAND_COMPANY(2, "中国大陆-企业"),
    HK_PERSONAL(3, "中国香港-个人"),
    HK_COMPANY(4, "中国香港-企业"),
    ;
    /** 编码 */
    private Integer enumCode;
    /** 说明 */
    private String enumName;
    RegisterType(Integer enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }
}
