package com.js.common.enums;

import com.js.common.util.DbEnum;
import com.js.common.util.Localisable;
import lombok.Getter;

@Getter
public enum CurrEnum implements DbEnum {
    CURR_CNY("CNY", "人民币"),
    CURR_USD("USD", "美元"),
    CURR_EUR("EUR", "欧元"),
    CURR_HKD("HKD", "港币"),
    CURR_GBP("GBP", "英镑"),
            ;
    /** 简称 */
    private String enumCode;
    /** 国名 */
    private String enumName;

    CurrEnum(String enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }

    @Override
    public String queryEnumCode() {
        return this.enumCode;
    }

    @Override
    public String keyName() {
        return this.enumName;
    }


}
