package com.js.common.constant;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by liuh on 2019/6/5.
 */
public class CommonConstant {

    /** 定义寻汇通知时创建者ID */
    public static final String SUNRATE_CREATE_ID = "SUNRATE";

    /** 定义寻汇通知时创建者名称 */
    public static final String SUNRATE_CREATE_NAME ="SUNRATE:";

    /** 定义发送短信templateType */
    public static final String SEND_SMS_TEMPLATE_TYPE = "SMS";
    /** 定义发送短信templateInnerId */
    public static final String SEND_SMS_TEMPLATE_INNER_ID = "verCode";

    /**
     * 调用寻汇锁汇接口单笔交易金额最小值
     */
    public static final BigDecimal SURATE_TRADE_MIN_AMT = new BigDecimal(10);

    /**
     * 调用寻汇锁汇接口单笔交易金额最大值
     */
    public static final BigDecimal SURATE_TRADE_MAX_AMT = new BigDecimal(50000);

    /**
     * 人民币币种
     */
    public static final String TRADE_CURRENCY_CNY = "CNY";

    /**
     * 离岸人民币币种
     */
    public static final String TRADE_CURRENCY_CNH = "CNH";

    /**
     * 个人标识
     */
    public static final String TYPE_PERSONAL = "SELF";

    /**
     * 企业标识
     */
    public static final String TYPE_COMPANY = "COMPANY";

    /**
     * 交易模式-买入模式
     */
    public static final String TXN_MODE_BUY = "0";

    /**
     * 交易模式-卖出模式
     */
    public static final String TXN_MODE_SELL = "1";

    /**
     * 汇付提现到账类型 T + 0
     */
    public static final String REMIT_TYPE_T0 = "1";

    /**
     * 汇付提现到账类型 T + 1
     */
    public static final String REMIT_TYPE_T1 = "2";

    public static final String XH_TRADE_CONFIRM = "02";

    public static final String XH_TRADE_IN_PASS = "03";

    public static final String XH_TRADE_OUT_FINISH = "09";
    //  受益人寻汇审核状态 （审核中）
    public static final String XH_BENEFICIARY_REBIEW = "0";
    //  受益人寻汇审核状态 （审核通过）
    public static final String XH_BENEFICIARY_PASS = "1";
    //  受益人寻汇审核状态 （未通过）
    public static final String XH_BENEFICIARY_NOT_PASS = "2";
    /**
     * 每页限制数据条数
     */
    public static final Integer PAGE_SIXE = 5;

    /**
     * 暂无店铺或者暂无产品类型最大可申请虚拟店铺数量
     */
    public static final Integer NO_STORE_MAX_APPLY_COUNT = 3;

    /**
     * 请求寻汇交易状态
     */
    public static final String SEND_SUNRATE_TXN_STATUS = "99";


    /**
     * 汇付状态 汇付结果0004成功0001失败
     */
    public static final String CHINA_RESULT_SUCCESS = "0004";
    public static final String CHINA_RESULT_ERROR = "0001";

    /**
     * 汇付开户状态 0开户成功 1开户失败 2开户审核中
     */
    public static final String CHINA_ACCOUNT_STATUS_SUCCESS="0";
    public static final String CHINA_ACCOUNT_STATUS_ERROR="1";
    public static final String CHINA_ACCOUNT_STATUS_VERIFYING="2";

    /**
     * 汇付开户类型0个人开户1企业开户
     */
    public static final String CHINA_OPEN_ACCOUNT_TYPE_PERSONAL="0";
    public static final String CHINA_OPEN_ACCOUNT_TYPE_ENTERPRISE="1";

    /**
     * 汇付代发状态
     * 处理状态010 初始化020已申请040回调成功030失败050部分成功
     */
    public static final String CHINA_HANDLE_STATUS_INIT="010";
    public static final String CHINA_HANDLE_STATUS_APPLY="020";
    public static final String CHINA_HANDLE_STATUS_ERROR="030";
    public static final String CHINA_HANDLE_STATUS_SUCCESS="040";
    public static final String CHINA_HANDLE_STATUS_PART="050";

    /**
     * 准入状态
     * 1待审核，2通过，3拒绝，4打回
     */
    public static final String LOAN_RISK_STATUS_VERIFY="1";
    public static final String LOAN_RISK_STATUS_ADOPT="2";
    public static final String LOAN_RISK_STATUS_REFUSE="3";
    public static final String LOAN_RISK_STATUS_REPULSE="4";

    /**
     * 贷款状态
     * 审核状态：10等待初审，11初审通过，12初审拒绝，20复审通过，21复审拒绝，22电子签章成功，23电子签章失败 30放款通过，31放款拒绝
     * 核心合同状态：-1合同废止，0未放款，1还款中，2逾期，3案件，4正常结清，5催收减免结清，6正常提前结清，7催收提前结清，8放款中
     */
    public static final String LOAN_APPLY_STATUS_INIT="10";
    public static final String LOAN_APPLY_STATUS_I_VERIFY_ADOPT="11";
    public static final String LOAN_APPLY_STATUS_I_VERIFY_REFUSE="12";
    public static final String LOAN_APPLY_STATUS_C_VERIFY_ADOPT="20";
    public static final String LOAN_APPLY_STATUS_C__VERIFY_ADOPT="21";
    public static final String LOAN_APPLY_STATUS_CONTRACT_ADOPT="22";
    public static final String LOAN_APPLY_STATUS_CONTRACT_ERROR="23";
    public static final String LOAN_APPLY_STATUS_LOAN_ADOPT="30";
    public static final String LOAN_APPLY_STATUS_LOAN_REFUSE="31";
    public static final String LOAN_APPLY_STATUS_CONTRACT_TER="-1";
    public static final String LOAN_APPLY_STATUS_NOT_LOAN="0";
    public static final String LOAN_APPLY_STATUS_REPAYMENT_ING="1";
    public static final String LOAN_APPLY_STATUS_BEOVERDUE="2";
    public static final String LOAN_APPLY_STATUS_CASE="3";
    public static final String LOAN_APPLY_STATUS_NORMAL_SETTLE="4";
    public static final String LOAN_APPLY_STATUS_RED_SETTLE="5";
    public static final String LOAN_APPLY_STATUS_NORMAL_ADVANCE_SETTLE="6";
    public static final String LOAN_APPLY_STATUS_COLL_ADVANCE_SETTLE="7";
    public static final String LOAN_APPLY_STATUS_LOAN_ING="8";
    /**
     * 贷款功能扭转状态
     * 1.店铺授权 2.贷款申请 3.等待贷款申请审核 4.贷款申请修改 44 贷款审核不通过5.申请提额
     * 6等待贷款提额审核  66提额审核不通过7审核通过 8.等待放款 9放款完成 10 还款
     */
     public static final String STORE_LOAN_AUTHORIZE="1";
     public static final String STORE_LOAN_APPLY="2";
     public static final String STORE_LOAN_APPLY_VERIFY_ING="3";
     public static final String STORE_LOAN_APPLY_UPDATE="4";
     public static final String STORE_LOAN_APPLY_UPDATE_NOT="44";
     public static final String STORE_LOAN_APPLY_QUOTA="5";
     public static final String STORE_LOAN_APPLY_QUOTA_VERIFY_ING_="6";
     public static final String STORE_LOAN_APPLY_QUOTA_NOT="66";
     public static final String STORE_LOAN_APPLY_QUOTA_VERIFY_ADOPT="7";
     public static final String STORE_LOAN_APPLY_QUOTA_LOAN_ING="8";
     public static final String STORE_LOAN_APPLY_QUOTA_LOAN_SUCCESS="9";
     public static final String STORE_LOAN_APPLY_QUOTA_REPAYMENT="10";

    /**
     * 推送贷款端状态
     * 10客户准入 20修改  30借款 40电子签章
     */
    public static final String CUSTOMER_RISK="10";
    public static final String CUSTOMER_RISK_UPDATE="20";
    public static final String CUSTOMER_LOAN_APPLY="30";
    public static final String CUSTOMER_LOAN_CONTRACT="40";

    /**
     * 申请状态 010待审核020申请成功030申请失败
     */
    public static final String LOAN_BILL_FILE_APPLY_STATUS_INIT="010";
    public static final String LOAN_BILL_FILE_APPLY_STATUS_SUCCESS="020";
    public static final String LOAN_BILL_FILE_APPLY_STATUS_FAIL="030";

    /**
     * 贷款状态 0申请中，1.使用中 2.已结清 3.有逾期 4.发放中 5.贷款失败
     */
    public static final String QUERY_LOAN_APPLY_STATUS_INIT="0";
    public static final String QUERY_LOAN_APPLY_STATUS_UES="1";
    public static final String QUERY_LOAN_APPLY_STATUS_SETTLE="2";
    public static final String QUERY_LOAN_APPLY_STATUS_EXPECT="3";
    public static final String QUERY_LOAN_APPLY_STATUS_GRANT="4";
    public static final String QUERY_LOAN_APPLY_STATUS_ERRER="5";

    /**
     * 贷款端接口状态码
     */
    public static final String LOAN_POST_SUCCESS="0000";
    public static final String LOAN_POST_ERRER="0001";

    /**
     * 还款中状态 0初始化，1自动还款处理中，2主动还款处理中，3逾期还款处理中，4案件还款处理中
     */
    public static final String LOAN_REPAYMENT_STATUS_INIT="0";
    public static final String LOAN_REPAYMENT_STATUS_AUTOMATIC="1";
    public static final String LOAN_REPAYMENT_STATUS_ACTIVE="2";
    public static final String LOAN_REPAYMENT_STATUS_BEOVERDUE="3";
    public static final String LOAN_REPAYMENT_STATUS_CASE="4";

    /**
     * 0初始化1还款中2成功3失败
     */
    public static final String LOAN_REPAYMENT_DETAILED_STATUS_INIT="0";
    public static final String LOAN_REPAYMENT_DETAILED_STATUS_ING="1";
    public static final String LOAN_REPAYMENT_DETAILED_STATUS_SUCCESS="2";
    public static final String LOAN_REPAYMENT_DETAILED_STATUS_EREER="3";

    /**
     * 身份证为长期的日期时间
     */
    public static final String effectiveDate = "9999-12-31";

    public static Date longFormatDate(){
        try{
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(effectiveDate);
        }catch (Exception ex){
            System.out.println("日期異常");
        }
        return null;
    }
}
