package com.js.common.JsException;

import com.js.common.enums.ResultEnum;
import lombok.Data;

/**
 * @ClassName: LogicException
 * @Description: 逻辑异常处理类
 * @Author: yjzhao
 * @Create: 2019-05-17  11:14
 **/
@Data
public class LogicException extends RuntimeException {
    /**
     * 异常信息
     */
    private String errorMsg;
    /**
     * 错误码
     */
    private Integer code;

    /**
     * @Author yjzhao
     * @Description 异常构造方法
     * @Date 2019/5/17 11:32
     * @Param [errorEnum]
     * @return 
     **/
    private LogicException(ResultEnum errorEnum) {
        super(errorEnum.getMsg());
        this.code = errorEnum.getCode();
        this.errorMsg = errorEnum.getMsg();
    }

    /**
     * 抛出逻辑异常
     *
     * @param errorEnum
     * @return
     */
    public static LogicException le(ResultEnum errorEnum) {
        return new LogicException(errorEnum);
    }
}
