package com.js.common.model.vo;

import com.js.common.enums.CertiFileType;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import lombok.*;

import java.io.Serializable;


@Data
public class FileVo implements Serializable {

    private static final long serialVersionUID = -5593336254765241717L;
    private String id;

    /**
     * 存放位置
     *
     * @mbggenerated
     */
    private String fileSavePath;

    /**
     * 显示位置
     *
     * @mbggenerated
     */
    private String fileShowPath;

    /**
     * 存放名称
     *
     * @mbggenerated
     */
    private String fileSaveName;

    /**
     * 显示名称
     *
     * @mbggenerated
     */
    private String fileShowName;

    /**
     * 文件缩略图存放地址
     *
     * @mbggenerated
     */
    private String fileThumbnailPath;

    /**
     * 文件类型[0:文档, 1:图片 ,2:视频, 3:其他]
     *
     * @mbggenerated
     */
    private FileType fileType;

    /**
     * 文件扩展名
     *
     * @mbggenerated
     */
    private String fileExt;

    /**
     * 文件大小
     *
     * @mbggenerated
     */
    private Integer fileSize;

    /**
     * 文件来源类型[0:通用, 1:实名证件, 2:合同文件, 3:生成交易报表]
     *
     * @mbggenerated
     */
    private FileResourceType fileResourceType;

    /**
     * ocr识别结果
     */
    private Object ocrData;

    private CertiFileType certiFileType;
}
