package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 还款操作
 */
@Data
public class RepaymentOperationReq implements Serializable {
    private static final long serialVersionUID = 122173851639481470L;

    /**
     * 贷款编号
     */
    private String loanNo;
    /**
     * 还款总金额
     */
    private BigDecimal repaymentAllAmt;
    /**
     * 还款账户编号
     */
    private BigDecimal accountNo;
    /**
     * 还款本金
     */
    private BigDecimal principalAmt;
    /**
     * 手续费
     */
    private BigDecimal proceduresAmt;
    /**
     * 利息
     */
    private BigDecimal plannedInterest;
    /**
     * 费用
     */
    private BigDecimal plannedInstFee;

    /**
     * KYC用户ID
     */
    private String kycNaturalId;

}
