package com.js.common.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 汇付开户查询请求参数
 */
@Data
@ApiModel(value="汇付开户查询（ChinaPNRQueryOpenAccountReq）",description="汇付开户查询")
public class ChinaPNRQueryOpenAccountReq implements Serializable {

    private static final long serialVersionUID = -1513703756018851418L;
    /**
     * 用户ID
     */
    @NotBlank(message = "用户ID不能为空")
    @ApiModelProperty(value = "用户ID")
    private String kycNaturalId;
    /**
     * 请求流水号
     */
    @ApiModelProperty(value = "请求流水号")
    private String  requestId;

    private String jsOpenAccountNo;
}
