package com.js.common.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 企业汇付开户
 */
@Data
@ApiModel(value="企业汇付开户（ChinaPNREnterpriseOpenAccountReq）",description="企业汇付开户对象")
public class ChinaPNREnterpriseOpenAccountReq implements Serializable {

    private static final long serialVersionUID = -1513703756018851418L;
    /**
     * 用户ID
     */
    @NotBlank(message = "用户ID不能为空")
    @ApiModelProperty(value = "用户ID")
    private String kycNaturalId;
    /**
     * 请求流水号
     */
    @ApiModelProperty(value = "请求流水号")
    private String requestId;
    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间")
    private String platformRegTime;
    /**
     * 企业名称
     */
    @ApiModelProperty(value = "企业名称")
    private String name;
    /**
     * 企业类型 1-个体工商户 2-企业
     */
    @ApiModelProperty(value = "企业类型 1-个体工商户 2-企业")
    private String type;
    /**
     * 法人姓名
     */
    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;
    /**
     * 法人证件类型
     */
    @ApiModelProperty(value = "法人证件类型")
    private String legalCertType;
    /**
     * 法人证件号
     */
    @ApiModelProperty(value = "法人证件号")
    private String legalCertId;
    /**
     * 法人证件时效日期
     */
    @ApiModelProperty(value = "法人证件时效日期")
    private String legalCertExpDateEnd;
    /**
     * 联系人证件失效日期
     */
    @ApiModelProperty(value = "联系人证件失效日期")
    private String contactCertExpDateEnd;
    /**
     * 企业地址
     */
    @ApiModelProperty(value = "企业地址")
    private String address;
    /**
     * 企业电话
     */
    @ApiModelProperty(value = "企业电话")
    private String phone;
    /**
     * 组织机构代码
     */
    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;
    /**
     * 组织机构代码失效日期
     */
    @ApiModelProperty(value = "织机构代码失效日期")
    private String orgExpDateEnd;
    /**
     * 营业执照号
     */
    @ApiModelProperty(value = "营业执照号")
    private String bizLicenseCode;
    /**
     * 营业执照失效日期
     */
    @ApiModelProperty(value = "营业执照失效日期")
    private String bizLicenseExpDateEnd;
    /**
     * 税务登记号
     */
    @ApiModelProperty(value = "税务登记号")
    private String taxRegCode;
    /**
     * 税务登记证失效日期
     */
    @ApiModelProperty(value = "税务登记证失效日期")
    private String taxRegExpDateEnd;
    /**
     * 开户银行
     */
    @ApiModelProperty(value = "开户银行")
    private String bankCode;
    /**
     * 账户类型 1-对公 2-对私
     */
    @ApiModelProperty(value = "账户类型 1-对公 2-对私")
    private String acctType;
    /**
     * 账号
     */
    @ApiModelProperty(value = "账号")
    private String bankAcct;
    /**
     * 户名
     */
    @ApiModelProperty(value = "户名")
    private String acctName;
    /**
     * 省份
     */
    @ApiModelProperty(value = "省份")
    private String province;
    /**
     * 地区
     */
    @ApiModelProperty(value = "地区")
    private String area;
    /**
     * 支行名称
     */
    @ApiModelProperty(value = "支行名称")
    private String bankBranch;
    /**
     * 收款行联行号
     */
    @ApiModelProperty(value = "收款行联行号")
    private String uniteBankCode;
    /**
     * 法人证件的影印件正面 图片地址
     */
    @ApiModelProperty(value = "法人证件的影印件正面")
    private String legalCertPhotoCopyF;
    /**
     * 法人证件的影印件反面
     */
    @ApiModelProperty(value = "法人证件的影印件反面")
    private String legalCertPhotoCopyB;
    /**
     * 营业执照影印件
     */
    @ApiModelProperty(value = "营业执照影印件")
    private String bizLicensePhotoCopy;
    /**
     * 组织机构代码证影印件
     */
    @ApiModelProperty(value = "组织机构代码证影印件")
    private String orgPhotoCopy;
    /**
     * 税务登记证影印件
     */
    @ApiModelProperty(value = "税务登记证影印件")
    private String taxRegPhotoCopy;
    /**
     * 开户许可证影印件
     */
    @ApiModelProperty(value = "开户许可证影印件")
    private String openLicensePhotoCopy;

    /**
     * 开户号
     */
    private String jsOpenAccountNo;

}
