package com.js.common.model.req;

import com.js.common.enums.CertiFileType;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CertiMainLandCompanyReq implements Serializable{
    private static final long serialVersionUID = 629431826803352798L;

    private String id;

    /**
     * 寻汇返回注册编号key
     */
    private String registerId;

    /**
     * 实名表主键ID
     */
    private String kycCertiId;

    /**
     * 企业名称
     */
    @NotBlank(message = "企业名称不能为空")
    private String companyName;

    /**
     * 营业执照生效日期
     */
    @NotNull(message = "营业执照生效日期不能为空")
    private Date bizLicenseExpDateStart;

    /**
     * 营业执照失效日期
     */
    @NotNull(message = "营业执照生效日期不能为空")
    private Date bizLicenseExpDateEnd;

    /**
     * 企业英文名称
     */
    @NotBlank(message = "企业英文名称不能为空")
    private String companyEngName;

    /**
     * 统一社会信用代码
     */
    @NotBlank(message = "统一社会信用代码不能为空")
    private String unifiedSocialCreditCode;

    /**
     * 企业性质ID
     */
    @NotBlank(message = "企业性质ID不能为空")
    private String companyNatureId;

    /**
     * 企业性质名称
     */
    @NotBlank(message = "企业性质不能为空")
    private String companyNatureName;

    /**
     * 企业经营地址
     */
    @NotBlank(message = "企业经营地址不能为空")
    private String companyAddress;

    /**
     * 店铺主要经营类别表ID
     */
    @NotBlank(message = "店铺主要经营类别ID不能为空")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @NotBlank(message = "店铺主要经营类别不能为空")
    private String storeBusinessTypeName;

    /**
     * 证件类型编码
     */
    @NotNull(message = "法定代表人证件类型CODE不能为空")
    private CertiFileType certiCardType;

    /**
     * 法定代表人姓名
     */
    @NotBlank(message = "法定代表人姓名不能为空")
    private String legalRepresentativeName;

    /**
     * 法定代表人证件号
     */
    @NotBlank(message = "法定代表人证件号不能为空")
    private String legalRepresentativeIdNo;

    /**
     * 法定代表人住址
     */
    @NotBlank(message = "法定代表人住址不能为空")
    private String legalRepresentativeAddress;

    /**
     * 身份证有效起始日期
     */
    @NotNull(message = "身份证有效起始日期不能为空")
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    @NotNull(message = "身份证是否长期有效不能为空")
    private Boolean longFlag;

    /**
     * 附件集合
     */
    @NotEmpty(message = "请上传附件信息")
    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;
}