package com.js.common.jsConstraint;

import cn.hutool.core.lang.Validator;
import com.js.common.annotation.Phone;
import com.js.common.constant.RegexConstant;
import org.apache.commons.lang.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * @ClassName: PhoneValidator
 * @Description: 手机号码校验
 * @Author: yjzhao
 * @Create: 2019-05-19  13:51
 **/
public class PhoneValidator  implements ConstraintValidator<Phone, String> {
    private boolean required = false;

    @Override
    public void initialize(Phone constraintAnnotation) {
        required = constraintAnnotation.required();
    }

    @Override
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if(required) {
            return Validator.isMobile(s);
        }else {
            if(StringUtils.isEmpty(s)) {
                return false;
            }else{
                return Validator.isMobile(s);
            }
        }
    }
}
