package com.js.common.util;


import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbEnumTypeHandler extends BaseTypeHandler<DbEnum> {
    private Class<DbEnum> type;

    public DbEnumTypeHandler(Class<DbEnum> type){
        this.type = type;
    }


    @Override
    public void setNonNullParameter(PreparedStatement ps, int i,
                                    DbEnum parameter, JdbcType jdbcType) throws SQLException {
        ps.setString( i , parameter.queryEnumCode());
    }

    @Override
    public DbEnum getNullableResult(ResultSet rs, String columnName)
            throws SQLException {
        String constant = rs.getString(columnName);
        if(rs.wasNull()){
            return null;
        }
        else{
            return convert(constant);
        }
    }

    @Override
    public DbEnum getNullableResult(ResultSet rs, int columnIndex)
            throws SQLException {
        String constant = rs.getString(columnIndex);
        if(rs.wasNull()){
            return null;
        }
        else{
            return convert(constant);
        }
    }


    public DbEnum getNullableResult(CallableStatement cs, int columnIndex)
            throws SQLException {
        String constant = cs.getString(columnIndex);
        if(cs.wasNull()){
            return null;
        }
        else{
            return convert(constant);
        }
    }

    private DbEnum convert(String constant) {
        DbEnum[] dbEnums = type.getEnumConstants();
        for (DbEnum dbEnum : dbEnums) {
            if(dbEnum.queryEnumCode().equals(constant)){
                return dbEnum;
            }
        }
        return null;
    }
}
