package com.js.common.model.vo;

import com.js.common.enums.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsTradeFundVO implements Serializable {
    private static final long serialVersionUID = -4565392582128338021L;

    private String tradeId;

    /**
     * 交易时间
     */
    private Date tradeDate;
    /**
     * 收款人名称
     */
    private String receiverName;
    /**
     * 币种
     */
    private String currency;
    /**
     * 币种描述
     */
    private String currencyDesc;
    /**
     * 收入金额
     */
    private BigDecimal inAmt;
    /**
     * 支出金额
     */
    private BigDecimal outAmt;
    /**
     * 账户余额
     */
    private BigDecimal availableBalance;
    /**
     * 手续费-收费比
     */
    private BigDecimal serviceCharge;

    /**
     * 手续费-收费比描述
     */
    private String serviceChargeDesc;

    /**
     * 类型
     */
    private TradeSubTypeEnum tradeSubType;

    private TradeTypeEnum tradeType;

    /**
     * 类型描述
     */
    private String tradeTypeDesc;

    /**
     * 交易单号
     */
    private String tradeNo;

    /**
     * 结汇汇率
     */
    private BigDecimal useRate;

    /**
     * 应收提现手续费-外币
     */
    private BigDecimal accountsReceivableFee;

    /**
     * 提现手续费
     */
    private BigDecimal chargeAmt;

    private ProcessStatusEnum processStatus;

    private String processStatusDesc;

    private String batchNo;

    private BigDecimal tradeAmt;

    private String receiverAcctName;

    private String receiverAcctNo;

    private String storeName;

    private StorePlateformEnum storePlateform;

    private SiteEnum storeTheSite;

    private String sunrateBankCardNo;
}