package com.js.common.model.vo;

import com.js.common.enums.ProcessStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySunrateBankTradeOutVO implements Serializable {
    private static final long serialVersionUID = -1375697405164769843L;

    private String id;
    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    private String kycSunrateBankId;

    /**
     * 锁汇流水号
     */
    private String lockNo;

    /**
     * 锁汇交易编号
     */
    private String txnNo;

    /**
     * 组织机构代码
     */
    private String orgCode;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 受益人名称
     */
    private String beneficiaryName;

    /**
     * 受益人账户号码
     */
    private String beneficiaryAcctNo;

    /**
     * 出账币种
     */
    private String payCur;

    /**
     * 出账金额
     */
    private BigDecimal payAmt;

    /**
     * 备注
     */
    private String remark;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    private ProcessStatusEnum processStatus;
}