package com.js.common.model.req;

import com.js.common.enums.WayJdBankCheckEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 银行卡二三四要素验证
 *
 * 基于京东万象
 * 官方网站 https://wx.jdcloud.com/market/datas/5/10920
 *
 * @author liuytianyu
 */
@Data
public class KycCheckBankReq implements Serializable {

    private static final long serialVersionUID = -4624119681393828698L;

    /**
     * 银行卡帐号
     */
    @NotBlank(message = "银行卡号不允许为空")
    String acctPan;

    /**
     * 持卡人姓名
     */
    @NotBlank(message = "持卡人姓名")
    String acctName;

    /**
     * 开卡使用的证件号码(目前只能用身份证)
     */
    String certId;

    /**
     * 电话号码
     */
    String phoneNum;

    /**
     * 校验类型
     */
    @NotNull(message = "校验类型不可为空")
    WayJdBankCheckEnum wayJdBankCheckEnum;

    /**
     * 是否调用真实接口，默认不调用
     */
    Boolean useReal = false;
}
