package com.js.common.model.req;

import com.js.common.enums.CertiFileType;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class KycCertiContactsReq implements Serializable {
    private static final long serialVersionUID = 5962696222964042172L;
    private String id;
    /**
     * 注册表主键ID
     */
    private String kycNaturalId;

    /**
     * 实名表主键ID
     */
    @NotBlank(message = "实名表主键ID不能为空")
    private String kycCertiId;

    /**
     * 联系人类型
     */
    private String contactType;

    /**
     * 联系人名称
     */
    @NotBlank(message = "名称不能为空")
    private String contactName;

    /**
     * 联系人证件类型
     */
    @NotNull(message = "证件类型不能为空")
    private CertiFileType idType;

    /**
     * 联系人证件类型名称
     */
    private String idTypeName;

    /**
     * 联系人证件号
     */
    @NotBlank(message = "证件号不能为空")
    private String idNo;

    /**
     * 联系人常用住址
     */
    @NotBlank(message = "常用住址不能为空")
    private String address;

    /**
     * 身份证有效起始日期
     */
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    private Boolean longFlag;

    /**
     * 联系人手机号
     */
    private String phoneNo;

    /**
     * 联系人邮箱
     */
    private String email;

    /**
     * 联系人状态
     */
    private String status;

    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;
}