package com.js.common.model.req;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.enums.StorePlateformEnum;
import com.js.common.enums.TradeSubTypeEnum;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class JsTradeFundReq implements Serializable {
    private static final long serialVersionUID = -1809553630528263895L;
    /**
     * 交易起始日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date tradeStartDate;
    /**
     * 交易结束日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date tradeEndDate;

    /**
     * 平台站点
     */
    private SiteEnum storeTheSite;

    /**
     * 平台
     */
    private StorePlateformEnum storePlateform;

    /**
     * 店铺Id
     */
    private String kycStoreId;

    private String kycNaturalId;

    private Integer startPage = 0;
    private Integer pageSize = 5;
}