package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;

@Data
public class JsPaySupplierUserInfoReq implements Serializable {
    private static final long serialVersionUID = 1L;

    private String id;

    private String kycNaturalId;

    /**
     * 收款方账户类型 1-对公 2-对私
     */
    private String bankAccType;

    private String beneficiaryId;
    /**
     * 供货商ID
     */
    private String supplierId;

    /**
     * 收款方户名
     */
    private String cusName;
    /**
     * 收款银行名称
     */
    private String rcvBankName;
    /**
     * 收款方银行所在地（地区国家代码，如：HK、CN、JP）
     */
    private String rcvBankCountry;
    /**
     * 收款方银行卡号
     */
    private String rcvBankCard;
    /**
     * 路由类型
     */
    private String routeType;
    /**
     * Sort Code银行分类号码
     */
    private String sortCode;
    /**
     * IBAN国际银行账号
     */
    private String iban;
    /**
     * 9位收款路线号码
     */
    private String rcvRouteNo;
    /**
     * SWIFT/BIC编码
     */
    private String swiftBic;
    /**
     * 银行地址
     */
    private String bankAddr;
    /**
     * 开户省份
     */
    private String rcvBankProvince;
    /**
     * 开户城市
     */
    private String rcvBankCity;
    /**
     * 收款银行开户支行名称
     */
    private String rcvBankSubbranch;
    /**
     * 收款方证件号
     */
    private String rcvCreditCode;
    /**
     * 收款方联系电话
     */
    private String rcvPhone;

    private String browserIP;

    private String payCur;
}
