package com.js.common.model.req;

import com.js.common.enums.SiteEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsKycChargeReq implements Serializable {
    private static final long serialVersionUID = 4559152824181221493L;

    private String id;

    /**
     * 注册信息表-用户表-主键ID
     */
    @NotBlank(message = "用户ID不能为空")
    private String kycNaturalId;

    /**
     * 店铺所在站点
     */
    private SiteEnum storeTheSite;

    /**
     * 收费类型(RATE-汇差,SERVICE_CHARGE-手续费)
     */
    @NotBlank(message = "收费类型不能为空")
    private String chargeType;

    /**
     * 归属类型（SELF-个人可用，ALL-所有账户可用）
     */
    private String belongToType;

    /**
     * 比例-以精确到小数位计算eg:0.0007
     */
    @NotNull(message = "收费值不能为空")
    private BigDecimal chargeScale;

    /**
     * 预留字段
     */
    private String reserved;

}