package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class ChinaPNRTransactionReq implements Serializable {
    /**
     * 用户 kycNaturalId
     */
    @NotBlank
    String kycNaturalId;

    /**
     * 批次号
     */
    @NotBlank
    String batchNo;

    /**
     * 进入汇付的币种代码（一般是人民币）
     */
    @NotBlank
    String currencyCode;

    /**
     * 订单还原总金额（一般是人民币）
     */
    @NotNull
    BigDecimal TotalAmount;

    /**
     * 使用的汇率
     *
     * 例：如果源币种为美金。则这里填 6.xxx
     */
    @NotNull
    BigDecimal exchangeRate;
}
