package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 流水表交易类型
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Getter
public enum TradeTypeEnum {
    TRADE_IN(0, "入账"),
    TRADE_WITHDRAW(1, "提现"),
    TRADE_PAYMENT(3, "付款"),
    TRADE_REPAYMENT(4, "还款"),
    ;
    /** 编码 */
    private Integer code;
    /** 说明 */
    private String desc;

    TradeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
