package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 还款类型
 * @Author: liuh
 * @Create: 2019-07-10
 **/
@Getter
public enum RepaymentType {
    REPAYMENT_NORMAL(0, "正常还款"),
    REPAYMENT_ADVANCE(1, "提前还款"),
    REPAYMENT_OVERDUE(1, "逾期还款"),
    ;
    /** 编码 */
    private Integer code;
    /** 说明 */
    private String desc;
    RepaymentType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
