package com.js.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @ClassName: LogFileEnum
 * @Description: 日志枚举
 * @Author: yjzhao
 * @Create: 2018-12-14  14:08
 **/
public enum LogFileEnum {
    //配置到logback.xml中的logger name="XXXLogger"
    //js-web-httpReq
    JS_WEB_HTTP_REQ("jsWebHttpReqLogger");

    private String loggerName;

    LogFileEnum(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public static LogFileEnum getAwardTypeEnum(String value) {
        LogFileEnum[] arr = values();
        for (LogFileEnum item : arr) {
            if (null != item && StringUtils.isNotBlank(item.loggerName)) {
                return item;
            }
        }
        return null;
    }

}
