package com.js.common.enums;

import com.js.common.util.DbEnum;
import lombok.Getter;

@Getter
public enum BatStatus implements DbEnum {

    TRADE_UNKNOWN("D0", "交易处理中"),
    TRADE_ALL_FAIL("D1", "交易全部失败"),
    TRADE_ALL_SUCC("D2", "交易全部成功"),
    TRADE_PART_SUCC("D3", "交易部分成功"),
    ;
    private String enumCode;
    private String enumName;

    BatStatus(String enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }

    @Override
    public String queryEnumCode() {
        return this.enumCode;
    }

    @Override
    public String keyName() {
        return this.enumName;
    }

    @Override
    public String toString() {
        return this.enumName;
    }
}
